// DirtTweakerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DirtTweaker.h"
#include "DirtTweakerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


char const * carNames[] = { "131",
							"205",
							"207",
							"307",
							"405",
							"555",
							"aqp",
							"att",
							"bah",
							"bss",
							"c6r",
							"cc2",
							"cc4",
							"cel",
							"che",
							"cli",
							"cme",
							"cor",
							"cr4",
							"del",
							"esc",
							"exi",
							"fen",
							"frl",
							"fto",
							"gt4",
							"ick",
							"k2k",
							"kam",
							"man",
							"me9",
							"n12",
							"nav",
							"paj",
							"pun",
							"rdw",
							"rmx",
							"sab",
							"sil",
							"sst",
							"str",
							"tac",
							"tou",
							"tri",
							"tun",
							"x3x",
							"xsa" };

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDirtTweakerDlg dialog

CDirtTweakerDlg::CDirtTweakerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDirtTweakerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDirtTweakerDlg)
	m_path = _T("");
	m_strong_brakes = 4;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDirtTweakerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDirtTweakerDlg)
	DDX_Text(pDX, IDC_GAME_PATH, m_path);
	DDX_CBIndex(pDX, IDC_COMBO_STRONG_BRAKES, m_strong_brakes);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDirtTweakerDlg, CDialog)
	//{{AFX_MSG_MAP(CDirtTweakerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_SET_TO_DEFAULTS, OnSetToDefaults)
	ON_BN_CLICKED(IDC_APPLY_TO_GAME, OnApplyToGame)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDirtTweakerDlg message handlers

BOOL CDirtTweakerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDirtTweakerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDirtTweakerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDirtTweakerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDirtTweakerDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CDirtTweakerDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}


bool CheckFileExists( CString name )
{
	FILE * f = fopen(LPCTSTR(name),"rb");
	if( f != NULL )
	{
		fclose(f);
		return true;
	}
	else
	{
		return false;
	}
}

void CDirtTweakerDlg::OnSetToDefaults() 
{
	UpdateData(TRUE);

	int restored = 0;

	// Restores the backup file
	for( int car = 0; car < sizeof( carNames ) / sizeof( carNames[0] ); car++ )
	{
		char const * name = carNames[car];

		CString mainName = m_path + "cars\\" + CString(name) + "\\" + CString(name) + ".csv";
		CString backupName = m_path + "cars\\" + CString(name) + "\\" + CString(name) + "_backup.csv";

		if( CheckFileExists( backupName ) )
		{
			if( CheckFileExists( mainName ) )
			{
				CopyFile( backupName, mainName );
				restored++;
			}
		}
	}

	char szBuffer[256];
	sprintf(szBuffer,"Restored backup copies of %d files", restored );
	AfxMessageBox(szBuffer);
}

							
void CDirtTweakerDlg::OnApplyToGame() 
{
	UpdateData( TRUE );

	if( m_path.GetLength() > 0 )
	{
		if( m_path.GetAt( m_path.GetLength() - 1) != '\\' )
		{
			m_path = m_path + "\\";
		}

		// This car is in the full game and the demo, so should detect the game directory
		//		correctly for both
		if( CheckFileExists( m_path+"cars\\n12\\n12.csv" ) )
		{
			Patch();
		}
		else
		{
			AfxMessageBox( CString("Failed to find file '"+m_path+"data\\cars\\n12\\n12.csv', has the path been entered correctly?" ) );

		}
	}
	else
	{
		AfxMessageBox( "Please enter the path for the game's data files" );
	}
}

void CDirtTweakerDlg::Patch()
{
	for( int car = 0; car < sizeof( carNames ) / sizeof( carNames[0] ); car++ )
	{
		char const * name = carNames[car];

		CString mainName = m_path + "cars\\" + CString(name) + "\\" + CString(name) + ".csv";
		CString backupName = m_path + "cars\\" + CString(name) + "\\" + CString(name) + "_backup.csv";

		if( CheckFileExists( mainName ) )
		{
			if( !CheckFileExists( backupName ) )
			{
				// There is no backup file, copy the original file to make a backup
				//		before we start messing around with it
				BackupFile( CString( name ) );
			}

			PatchFile( backupName, mainName );
		}
		else
		{
			// Car doesn't exist. Perhaps this is the demo?
			// Anyway, just silently ignore it, can't patch a car that isn't there
		}
	}

	AfxMessageBox("Tweak process finished");
}

void CDirtTweakerDlg::BackupFile(CString name)
{
	CString source = m_path + "cars\\" + CString(name) + "\\" + CString(name) + ".csv";
	CString dest = m_path + "cars\\" + CString(name) + "\\" + CString(name) + "_backup.csv";

	CopyFile( source, dest );
}

void CDirtTweakerDlg::PatchFile(CString inName, CString outName)
{
	FILE * in = fopen(LPCTSTR(inName),"rb");
	if( in != NULL )
	{
		FILE * out = fopen(LPCTSTR(outName),"wb");

		if( out != NULL )
		{
			PatchOpenFiles( in, out );

			fclose(out);
		}
		else
		{
			AfxMessageBox( CString("Failed to open file for modifying '") + outName + "' when trying to patch data. Ensure the file is not read-only" );
		}

		fclose(in);
	}
	else
	{
		AfxMessageBox( CString("Failed to open backup file '") + inName + "' when trying to patch data" );
	}
}

void CDirtTweakerDlg::PatchOpenFiles(FILE *in, FILE *out)
{
	int currentEntryIndex = 0;
	char szCurrentEntry[1024];
	szCurrentEntry[0] = '\0';

	bool readLastEntry = false;

	while( !readLastEntry )
	{
		char c;

		if( feof(in) )
		{
			c = 0x0d;
			readLastEntry = true;
		}
		else
		{
			if( fread(&c,1,1,in) > 0 )
			{
				// Read a byte ok
			}
			else
			{
				c = 0x0d;
			}
		}

		if( (c == ',') || (c == 0x0d) )
		{
			// Modify current entry
			ModifyEntry( szCurrentEntry, currentEntryIndex );
			int currentLength = strlen( szCurrentEntry );

			// Write to output file
			if( currentLength > 0 )
			{
				fwrite(szCurrentEntry,1,currentLength,out);
			}
			fwrite(&c,1,1,out);
			if( c == 0x0d )
			{
				c = 0x0a;
				fwrite(&c,1,1,out);
			}

			// And move onto the next entry
			if( c == ',' )
			{
				// new entry to follow
				currentEntryIndex++;
			}
			else
			{
				// new car to follow
				currentEntryIndex = 0;
			}

			szCurrentEntry[0] = '\0';
		}
		else
		{
			if( c != 0x0a )
			{
				int currentLength = strlen( szCurrentEntry );

				szCurrentEntry[currentLength] = c;
				szCurrentEntry[currentLength+1] = '\0';
			}
		}
	}
}

void CDirtTweakerDlg::ModifyEntry(char *data, int index)
{
	//////////////////////////////////////////////
	// IMPORTANT NOTE
	//
	// It is very important that when in the default state the
	// text in 'data' is unmodified so that the checksums on
	// the mechanics files will come through correctly. E.g.
	//	without the != 4 check on the strong brakes the existing
	//	value would be reformatted to 3 decimal places in the output
	//	file which would be enough to stop the checksums working
	//
	// Also, if adding stuff here be sure to have the values set to
	//	some sensible defaults in the OnSetToDefaults() function

	//////////////////////////////////////////////
	// Remove extra strong brakes
	if( m_strong_brakes != 4 )
	{
		if( index == 278 )
		{
			char * pcDummy;
			double currentValue = strtod( data, &pcDummy );
			sprintf(data,"%.3f", (float) ((double)m_strong_brakes * currentValue * 0.25) );
		}
	}
}

void CDirtTweakerDlg::CopyFile(CString source, CString dest)
{
	FILE * out = fopen(LPCTSTR(dest),"wb");
	if( out != NULL )
	{
		FILE * in = fopen(LPCTSTR(source),"rb");

		fseek(in,0,SEEK_END);
		int size = ftell(in);
		fseek(in,0,SEEK_SET);

		unsigned char * buffer = new unsigned char[size];

		fread(buffer,1,size,in);
		fwrite(buffer,1,size,out);

		fclose(out);
		fclose(in);
	}
	else
	{
		AfxMessageBox("Failed to open file for writing, process will fail" );
	}
}
